%Run the COVID model with baseline parameters but faster vaccines for the BPEA
%This file calls two additional files
%omicronrunthemodelBPEAfastvaccines.m 
%omicronodefileBPEAfastvaccines.m
%vaccines are set to continue in the file
%omicronodefileBPEAfastvaccines.m line 56
 

clear all;
close all;
set(groot,'defaultLineLineWidth',2.0);
%for figure numbers
hh = 1;



%SET PARAMETERS

%baseline (this is a legacy variable that does not do anything)
indexparams = 1;

%first set the length of the simulation in years 
t0 = 0;  
tfinal = 4*365;


%US population 
population = 332000000;


%INFECTION FATALITY RATES

%infection fatality rates for prior variants in 2020
%in omicronodefileBPEAbaseline.m this is set to drop in 2021 when t gets to that
%point
eta = 0.01;

%infection fatality rate for initial infections with Omicron
%In omicronodefileBPEAbaseline.m this is set to drop gradually in 2022 
etaO = 0.0015;

%infection fatality rate with breakthrough infections with Omicron
etaO2 = 0.015*etaO;




%WANING IMMUNITY

%waning immunity first three variants is set here
xi = 1/(3*365);

%probability of a breakthrough infection with Omicron. 
nuO = 1/12;

%speed with which Omicron wanes
xiO = 1/(3*365);

%FLOW RATES

%flow rate out of hospitalization
zeta = 1/30;

%flow rate out of infectious status
gamma = 0.4;
%flow rate out of exposed status
sigma = 0.425;

%VARIANT TRANSMISSION RATES

% basic reproduction number for original variant is 3
betabar = 3*gamma;
% ratio of Alpha to original basic reproduction number
betabarv = 4*gamma;
%betabarv = 1.4*betabar;
% ratio of Delta to Alpha basic reproduction number
betabarv2 = 8*gamma;
%the transmission rate of Omicron is set to give it a certain growth
%advantage over Delta including its ability for breakthrough infections
%This was calculated off of South African data from late 2021
%This is done below


%If we assume that 15 percent of South Africans were susceptible and 85
%percent had prior infections, then the infectiousness of Omicron is given
%by
OmicrontoDeltaReffinSA = 3;

betabarv3 = betabarv2*OmicrontoDeltaReffinSA*(0.15/(0.15+nuO*0.85));
%where 3 is the ratio of the growth rates of these
%variants in Gautang in October and November of 2021 and 0.15 and 0.85 are
%the portions of that population estimated suspectible and recovered at that time


%VARIANT INTRODUCTION DATES

%the introduction of the new variant Alpha is here
tv = 289;
Evbar = 1/population;


%the introdution of the new variant Delta is here
tv2 = 435;
Evbar2 = 1/population;


%Omicron
tv3 = 637;
Evbar3 = 1/population;

%BEHAVIOR

%baseline value of kappa set here
kappa = 2.5000e+05;

%there are the parameters controlling the reduction in the sensitivity of
%transmission to the death rate in the fall of 2020
fatiguesize = 0.375;

fatiguemean = 285;
fatiguesig = 15;



%VACCINES

%vaccine rate set here for original vaccines
lambda = 0.0065;
%In the file omicronodefileBPEAbaseline.m, the vaccines are set to start
%321 days in and then taper off after another 185 days and then end 365
%days after being introduced

%SEASONALITY
%these are the parameters controlling the seasonal effect in transmission
seasonalsize = 0.35;

seasonalposition = 20;

%LOAD US DEATHS DATA

%Now enter the data on weekly and cumulative COVID deaths

COVIDdeathsdata = [43876	6	16
43883	6	22
43890	9	31
43897	38	69
43904	60	129
43911	586	715
43918	3211	3926
43925	10113	14039
43932	16306	30345
43939	17201	47546
43946	15525	63071
43953	13200	76271
43960	11223	87494
43967	9229	96723
43974	7229	103952
43981	6160	110112
43988	5046	115158
43995	4227	119385
44002	3844	123229
44009	3835	127064
44016	4540	131604
44023	5770	137374
44030	7166	144540
44037	8229	152769
44044	8285	161054
44051	7848	168902
44058	7248	176150
44065	6374	182524
44072	5739	188263
44079	5010	193273
44086	4618	197891
44093	4273	202164
44100	4296	206460
44107	4240	210700
44114	4813	215513
44121	5195	220708
44128	5990	226698
44135	7019	233717
44142	8754	242471
44149	10644	253115
44156	13343	266458
44163	15615	282073
44170	18545	300618
44177	20913	321531
44184	22314	343845
44191	23364	367209
44198	24845	392054
44205	25974	418028
44212	25692	443720
44219	23687	467407
44226	20322	487729
44233	17034	504763
44240	13519	518282
44247	10807	529089
44254	8654	537743
44261	6731	544474
44268	5725	550199
44275	4893	555092
44282	4461	559553
44289	4197	563750
44296	4313	568063
44303	4450	572513
44310	4601	577114
44317	4165	581279
44324	4006	585285
44331	3678	588963
44338	3238	592201
44345	2770	594971
44352	2347	597318
44359	2035	599353
44366	1776	601129
44373	1635	602764
44380	1543	604307
44387	1645	605952
44394	1991	607943
44401	2760	610703
44408	4105	614808
44415	6484	621292
44422	9406	630698
44429	12181	642879
44436	14174	657053
44443	15493	672546
44450	15417	687963
44457	15211	703174
44464	14347	717521
44471	12830	730351
44478	11180	741531
44485	9878	751409
44492	8941	760350
44499	7960	768310
44506	7287	775597
44513	7159	782756
44520	7310	790066
44527	7886	797952
44534	8781	806733
44541	9734	816467
44548	10250	826717
44555	10458	837175
44562	11677	848852
44569	15125	863977
44576	19078	883055
44583	21335	904390
44590	20966	925356
44597	18756	944112
44604	15317	959429
44611	11566	970995
44618	8290	979285
44625	6041	985326
44632	4404	989730
44639	3125	992855
44646	2505	995360
44653	1908	997268
44660	1552	998820
44667	1410	1000230
44674	1345	1001575
44681	1426	1003001
44688	1433	1004434
44695	1676	1006110
44702	1742	1007852
44709	1940	1009792
44716	2007	1011799
44723	2139	1013938
44730	2194	1016132
44737	2329	1018461
44744	2420	1020881
44751	2588	1023469
44758	2929	1026398
44765	3226	1029624
44772	3401	1033025
44779	3372	1036397
44786	3284	1039681
44793	3166	1042847
44800	3050	1045897
44807	2926	1048823
44814	2807	1051630
44821	2513	1054143
44828	2546	1056689
44835	2377	1059066
44842	2194	1061260
44849	2147	1063407
44856	2196	1065603
44863	2242	1067845
44870	2248	1070093
44877	2201	1072294
44884	2256	1074550
44891	2497	1077047
44898	2592	1079639
44905	3035	1082674
44912	3187	1085861
44919	3319	1089180
44926	3658	1092838
44933	3869	1096707
44940	3689	1100396
44947	3247	1103643
44954	2909	1106552
44961	2642	1109194
44968	2348	1111542
44975	2099	1113641
44982	2158	1115799
44989	1993	1117792
44996	1852	1119644
45003	1765	1121409
45010	1667	1123076
45017	1448	1124524
45024	1372	1125896
45031	1218	1127114
45038	1193	1128307
45045	1025	1129332
45052	942	1130274
45059	837	1131111
45066	757	1131868
45073	741	1132609
45080	693	1133302
45087	633	1133935
45094	612	1134547
45101	579	1135126
45108	543	1135669
45115	490	1136159
45122	507	1136666
45129	538	1137204
45136	547	1137751
45143	670	1138421
45150	751	1139172
45157	918	1140090
45164	1062	1141152
45171	1187	1142339
45178	1308	1143647
45185	1406	1145053
45192	1415	1146468
45199	1450	1147918
45206	1395	1149313
45213	1310	1150623
45220	1391	1152014
45227	1287	1153301
45234	1244	1154545
45241	1386	1155931
45248	1425	1157356
45255	1415	1158771
45262	1713	1160484
45269	1784	1162268
45276	1830	1164098
45283	1919	1166017
45290	2202	1168219
45297	2459	1170678
45304	2547	1173225
45311	2320	1175545
45318	2088	1177633
45325	1690	1179323
45332	1550	1180873
45339	1330	1182203];

COVIDdeathsdates = datetime(COVIDdeathsdata(:,1),'ConvertFrom','excel');


%CREATE SEROPREVALENCE DATA

sdate = [43876.00	44027.00	44055.00	44088.00	44117.00	44148.00	44178.00	44210.00	44240.00	44270.00	44300.00	44330.00	44361.00	44393.00	44419.00	44454.00	44481.00	44511.00	44541.00	44650.00	44742.00	44834.00	44926.00];
sdate = sdate - sdate(1);
sdatelabel = datetime('15-Feb-2020')+days(sdate);
sdatecl = [43876.00	44056.00	44070.00	44084.00	44098.00	44112.00	44126.00	44150.00	44164.00	44177.00	44248.00	44262.00	44276.00	44290.00	44304.00	44318.00	44332.00	44346.00	44360.00	44374.00	44388.00	44472.00	44500.00	44528.00	44556.00	44590.00	44618.00];
sdatecl = sdatecl - sdatecl(1);
sdatelabelcl = datetime('15-Feb-2020')+days(sdatecl);
cprevalence = [0	0.037	0.048	0.05	0.059	0.082	0.119	0.205	0.335	0.492	0.714	0.833	0.874	0.888	0.896	0.918	0.929	0.939	0.947	0.922	0.9431	0.9599	0.9671];
cprevalence65 = [0 0.015	0.027	0.025	0.03	0.04	0.063	0.119	0.38	0.728	0.891	0.922	0.93	0.944	0.943	0.952	0.955	0.958	0.963	0.8846	0.9046	0.9305	0.9252];
iprevalence = [0	0.035	0.047	0.049	0.057	0.079	0.115	0.159	0.184	0.198	0.207	0.202	0.206	0.202	0.219	0.245	0.262	0.278	0.288	0.4876	0.5871	0.7019	0.7754];
iprevalence65 = [0 0.013	0.025	0.023	0.028	0.038	0.061	0.091	0.115	0.109	0.117	0.117	0.119	0.122	0.128	0.146	0.16	0.166	0.167	0.2598	0.3256	0.4661	0.5646];
iprevalencecl = [0 0.059	0.062	0.064	0.068	0.068	0.072	0.08	0.094	0.115	0.2	0.208	0.204	0.207	0.218	0.214	0.221	0.215	0.216	0.211	0.206	0.292	0.307	0.316	0.335	0.433	0.577];
iprevalencecl65 = [0 0.025	0.034	0.033	0.031	0.036	0.039	0.039	0.054	0.063	0.124	0.132	0.134	0.131	0.13	0.136	0.124	0.127	0.124	0.126	0.128	0.163	0.171	0.175	0.191	0.233	0.332];

%RUN THE MODEL WITH THIS FILE
omicronrunthemodelBPEAfastvaccines;

%PREPARE FOR PLOTTING RESULTS

%compute cumulative deaths over the simulation  period

cumulativedeaths = D1(length(D1))*population;

t1date = datetime('15-Feb-2020')+t1;

psit = seasonalsize*(cos((t1+seasonalposition)*2*pi/365)-1)/2;
kappat = kappa*(1 -normcdf(t1,fatiguemean,fatiguesig))+fatiguesize*kappa*normcdf(t1,fatiguemean,fatiguesig);
betat = betabar.*exp(-kappat.*zeta.*H1+psit);
betavt = betabarv.*exp(-kappat.*zeta.*H1+psit);
betav2t =  betabarv2.*exp(-kappat.*zeta.*H1+psit);
betav3t =  betabarv3.*exp(-kappat.*zeta.*H1+psit);


%PLOT DAILY DEATHS

figure(hh)

plot(t1date,zeta*H1*population,COVIDdeathsdates,COVIDdeathsdata(:,2)/7,'-.')
%plot(t1date,zeta*H1*population,tdatadateW,USdataW(:,2)/7,'-.')
%title('Daily Deaths US')
xlabel('date')
h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
exportgraphics(gcf,'FigureA5Right.pdf','ContentType','vector')

hh = hh+1;

%uncomment these lines to write an Excel file
%writematrix(t1date,'Figure2Left.xls','Range','A1');
%writematrix(zeta*H1*population,'Figure2Left.xls','Range','B1');
%writematrix(COVIDdeathsdates,'Figure2Left.xls','Range','C1');
%writematrix(COVIDdeathsdata(:,2)/7,'Figure2Left.xls','Range','D1');

%PLOT CUMULATIVE DEATHS

figure(hh)
plot(t1date,D1*population,COVIDdeathsdates,COVIDdeathsdata(:,3),'-.')
%title('Cumulative COVID Deaths')
xlabel('date')
h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
exportgraphics(gcf,'FigureA5Left.pdf','ContentType','vector')

hh = hh+1;

fprintf('Cumulative Deaths Data = %d \n',COVIDdeathsdata(length(COVIDdeathsdates),3)) 

fprintf('Cumulative Deaths with faster vaccines = %d \n',floor(D1(end)*population)) 

%uncomment these lines to write an Excel file
%writematrix(t1date,'Figure2Right.xls','Range','A1');
%writematrix(D1*population,'Figure2Right.xls','Range','B1');
%writematrix(COVIDdeathsdates,'Figure2Right.xls','Range','C1');
%writematrix(COVIDdeathsdata(:,3),'Figure2Right.xls','Range','D1');




